#!/bin/sh -e
# ESET PROTECT
# Copyright (c) 1992-2024 ESET, spol. s r.o. All Rights Reserved

cleanup_file="$(mktemp -q)"
finalize()
{
  set +e
  if test -f "$cleanup_file"
  then
    while read f
    do
      rm -f "$f"
    done < "$cleanup_file"
    rm -f "$cleanup_file"
  fi
}

trap 'finalize' HUP INT QUIT TERM EXIT

eraa_server_hostname="kyfrkp3tlteulmaj3disfpaezy.a.ecaserver.eset.com"
eraa_server_port="443"
eraa_server_company_name='CPAS de Waterloo'
eraa_peer_cert_b64="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"
eraa_peer_cert_pwd=""
eraa_ca_cert_b64="MIIFpDCCA4ygAwIBAgIIMUSW0eFkh/8wDQYJKoZIhvcNAQELBQAwaDELMAkGA1UEBhMCU0sxGDAWBgNVBAgTD1Nsb3ZhayBSZXB1YmxpYzETMBEGA1UEBxMKQnJhdGlzbGF2YTENMAsGA1UEChMERXNldDEbMBkGA1UEAxMSRVBDIEFnZW50IHByb3h5IENBMB4XDTIyMDYyMDAwMDAwMFoXDTMyMDYxOTIzNTk1OVowaDELMAkGA1UEBhMCU0sxGDAWBgNVBAgTD1Nsb3ZhayBSZXB1YmxpYzETMBEGA1UEBxMKQnJhdGlzbGF2YTENMAsGA1UEChMERXNldDEbMBkGA1UEAxMSRVBDIEFnZW50IHByb3h5IENBMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEApFyygZ31hn6s/K7+Lm/r3KP+P5Gn0pb5J6IR0F+KtBUiNE9nRn5PnVDdyj9uVd6BZIKcczoHebH/70GQUuOzprDtHhWUTNDZ7R4NfNz0u5cYn2mKPk9lJRPEcuvqKr+aGsCs1yMv226xd72ngJE/Z2MlGLGX5+kuO0HmQWRUK/SDtmcCvforHs7zE19PjXmZQnpW+bUFkLeHcHS4WtJ64CNkbuTHssK8nNDQoJXLZVKafLWCkAZ94vpZWDRG5AffdBDnKrSy+WOTI6dOJw8i+uJ7YtWconTJo9NRCcgTzCHujylXgqWkwm3f+Wh/h0u5KIJEzTPN/RTzP+/SWEDrYi7+wECXWv6kU3Ty3KkzPGsAt9ABmnvAUGShi8Heyhnes6E3IiUt3wko+LHVw9hFyXFjfqtgRtxvOTcX06zinpQbtl+d1Wm7mU/ORFIPffRec4B9YewF1VRCm4gT5vqFZbO7BUnuyKFeGr6Vxlgrgz0mPS0PAoATI500x9g8Md3Mmshc/6wLInMHgSh//n+aylnePRrTvLEJhcWgoDx57wZ7G5fTeHEFIRrcU3ez6PSKbodCBcjfWrGLkXNQzmIwhDxVRmo4DXLga6MzbYqU54zQVfk60CiFEvwwK8l7WBZ7XlqxRl8QmsIUGf278N8Hxe0qOs7fcZPvuVHyhS4WKxsCAwEAAaNSMFAwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUZ9DJSflsyGkpLas5Ll3dMzeMJSEwCwYDVR0PBAQDAgEGMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQsFAAOCAgEAWrXSFAd4OmT0bxHj1q+zMROTxXalzfAfqncTGaTm2NiqL5be3WfgnQLjGOMX+VVC1YXDlI2xs2JAWD3myRT4u7g1Y320HmjWczaE36h8PrnL+M/LEIHem3bM7e6ZFGHzwN80D5bmM++qacrGnnSDXid/sVx2Vi5KKXOXcFB74Haef5mqVm9uNpjDuUO+7Zdip6xqieHOpYD7HIWCkq/bJXxyrPr9CY37KyVdeMoU8QuIzdlgn5l0yc8LNBXXv7pba+ykPirIWe1ZR0O0z5e0gAqUe0kz9fpiMmzWpaGS/4s8gt0oYX2Ahibc3Lgg179OOpUFOsz92TmPVQCnzseZCPirikCA7qUAmMFKqs+l+X6DdKIrL4ocHs5zFAL9fysdKpczKczAWpZXr9LtuY6WFDkcWhxm4kj1MXyte8UBBC4C1UX47Km5TlOQUApnp7LMXI3jlBB+2Lo3T9N2FhiQ5R2PoNdA+XONNaBb8E9mh83wOvA6+Me1Rb7bIO6q/dTULd41Jns3JQ8zy0H8rQrOSOREWfieW0Czd38ZRJoa7MRp6Z3aYAuqt8pJpOykVbKQY/OYh43pt5gfgFvIkI3CuoJvLPQ3bYKyBiJN8PYhFpOyLYOrOJqbd26x+QFORgiBdZo6u6Em31l3fVpiaMcSAD9Cny6VUEC2aYn00beB2Vc="
eraa_product_uuid=""
eraa_initial_sg_token=""
eraa_policy_data=""

arch=$(uname -m)
eraa_installer_url="http://repository.eset.com/v1/com/eset/apps/business/era/agent/v11/11.4.1107.0/agent_linux_i386.sh"
eraa_installer_checksum="dd66ae255e60f309cad0fad025cf0d3d881ac575537ad7cc158f074ab8a7c8af"

if $(echo "$arch" | grep -E "^(x86_64|amd64)$" 2>&1 > /dev/null)
then
    eraa_installer_url="http://repository.eset.com/v1/com/eset/apps/business/era/agent/v11/11.4.1107.0/agent_linux_x86_64.sh"
    eraa_installer_checksum="2c49d9c9d50c13663fac0c0ad499d61ea9e17c4ec3f9907bbe5a2dc91b8df669"
else
    if $(echo "$arch" | grep -E "^(aarch64|arm64)$" 2>&1 > /dev/null)
    then
        eraa_installer_url=""
        eraa_installer_checksum=""
    fi
fi

echo "ESET Management Agent live installer script. Copyright © 1992-2024 ESET, spol. s r.o. - All rights reserved."

if test ! -z "$eraa_server_company_name"
then
  echo " * CompanyName: $eraa_server_company_name"
fi
echo " * Hostname: $eraa_server_hostname"
echo " * Port: $eraa_server_port"
echo " * Platform: $arch"
echo " * Installer: $eraa_installer_url"
echo

if test -z "$eraa_installer_url"
then
  echo "No installer available for '$arch' arhitecture."
  exit 1
fi

local_cert_path="$(mktemp -q -u)"
echo $eraa_peer_cert_b64 | base64 -d > "$local_cert_path" && echo "$local_cert_path" >> "$cleanup_file"

if test -n "$eraa_ca_cert_b64"
then
  local_ca_path="$(mktemp -q -u)"
  echo $eraa_ca_cert_b64 | base64 -d > "$local_ca_path" && echo "$local_ca_path" >> "$cleanup_file"
fi


eraa_http_proxy_value=""

local_installer="$(dirname $0)"/"$(basename $eraa_installer_url)"

if $(echo "$eraa_installer_checksum  $local_installer" | sha256sum -c 2> /dev/null > /dev/null)
then
    echo "Verified local installer was found: '$local_installer'"
else
    local_installer="$(mktemp -q -u)"

    echo "Downloading ESET Management Agent installer..."

    if test -n "$eraa_http_proxy_value"
    then
      export use_proxy=yes
      export http_proxy="$eraa_http_proxy_value"
      (wget --connect-timeout 300 --no-check-certificate -O "$local_installer" "$eraa_installer_url" || wget --connect-timeout 300 --no-proxy --no-check-certificate -O "$local_installer" "$eraa_installer_url" || curl --fail --connect-timeout 300 -k "$eraa_installer_url" > "$local_installer") && echo "$local_installer" >> "$cleanup_file"
    else
      (wget --connect-timeout 300 --no-check-certificate -O "$local_installer" "$eraa_installer_url" || curl --fail --connect-timeout 300 -k "$eraa_installer_url" > "$local_installer") && echo "$local_installer" >> "$cleanup_file"
    fi

    if test ! -s "$local_installer"
    then
       echo "Failed to download installer file"
       exit 2
    fi

    echo -n "Checking integrity of installer script " && echo "$eraa_installer_checksum  $local_installer" | sha256sum -c
fi

chmod +x "$local_installer"

command -v sudo > /dev/null && usesudo="sudo -E" || usesudo=""

export _ERAAGENT_PEER_CERT_PASSWORD="$eraa_peer_cert_pwd"

echo
echo Running installer script $local_installer
echo

$usesudo /bin/sh "$local_installer"\
   --skip-license \
   --hostname "$eraa_server_hostname"\
   --port "$eraa_server_port"\
   --cert-path "$local_cert_path"\
   --cert-password "env:_ERAAGENT_PEER_CERT_PASSWORD"\
   --cert-password-is-base64\
   --initial-static-group "$eraa_initial_sg_token"\
   \
   --disable-imp-program\
   $(test -n "$local_ca_path" && echo --cert-auth-path "$local_ca_path")\
   $(test -n "$eraa_product_uuid" && echo --product-guid "$eraa_product_uuid")\
   $(test -n "$eraa_policy_data" && echo --custom-policy "$eraa_policy_data")
